**************************************************************************************************************************************************
******************* Code for 'Are Investment Tax Breaks Effective: Australian Evidence' *******************
***************************************************** Code for RDD data construction ******************************************************************

**************************************************DATE: Jun 2024 ******************************************************************************
*********************************************************************************************************************************************
*** Code strcuture
*01. Laod and clean
*02 MAke variables


************* 01. Laod data nd clean **********					  

if "$ids"=="id" {
	use "$data\bas_bit_frame_adjs_20.dta", clear
	 keep if latest_sisca08==4000 | latest_sisca08==1001 | latest_sisca08==1009

}
if "$ids"=="id_bg" {
	use "$data\bas_bit_bas_frame_adjs_bg_20.dta", clear
	 keep if sisca==4000 | sisca==1001 | sisca==1009

}
compress
drop if  division == "B" | division == "K"
g div = 1
replace div = 2 if industry > 599 & industry < 1100
replace div = 3 if industry > 1099 & industry < 2600
replace div = 4 if industry > 2599 & industry < 3000
replace div = 5 if industry > 2999 & industry < 3300
replace div = 6 if industry > 3299 & industry < 3900
replace div = 7 if industry > 3899 & industry < 4400
replace div = 8 if industry > 4399 & industry < 4600
replace div = 9 if industry > 4599 & industry < 5400
replace div = 10 if industry > 5399 & industry < 6200
replace div = 11 if industry > 6199 & industry < 6500
replace div = 12 if industry > 6599 & industry < 6800
replace div = 13 if industry > 6799 & industry < 7100
replace div = 14 if industry > 7199 & industry < 7400
replace div = 15 if industry > 7499 & industry < 8000
replace div = 16 if industry > 7999 & industry < 8300
replace div = 17 if industry > 8399 & industry < 8800
replace div = 18 if industry > 8899 & industry < 9300
replace div = 19 if industry > 9399 & industry < 9999

* Geneate a few series we might need
egen firmid=group($ids)
g period = year*4+quarter
xtset firmid period
************* 01.  Make varaibles**********					  

g lcapex = log(capex)

g capex_4 = l4.capex
g capex_8 = l8.capex

g lcapex_4 = ln(capex_4)
g lcapex_8 = ln(capex_8)

g q_to_grow = ln(turnover)-ln(l_turnover)
g y_to_grow = ln(turnover)-ln(l4_turnover)

g lrev = ln(income)
g ln_wages= ln(wages)
g lturnover= ln(turnover)
*Construct regression variables 2M CUTT OFF
g sales2_c = income_l2-$lb2
g sales2_2c = sales2_c^2


g sales2_1_c = income_l-$lb2


*Construct regression variables 10M CUTT OFF
g sales10_c = income_l2-10000000

g sales10_1_c = income_l-10000000


*Construct regression variables 50M CUTT OFF
g sales50_c = income_l2-50000000


g sales50_1_c = income_l-50000000

*Construct regression variables 500M CUTT OFF
g sales500_c = income_l2-500000000


g sales500_1_c = income_l-500000000


foreach div in A C D E F G H I J L M N O P Q R S {
	g `div'_div = (division=="`div'")
}
drop A_div

compress
capture drop first_bg_fr bg_counts_fr mult_bg sub_firms income_eg income_l_eg income_l2_eg latest_anzsic06_eg sisca08_eg latest_anzsic06 sisca08 gov non_fin_prof non_prof mod_ind mode_ind_eg
save  "$data\rdd_$ids.dta", replace

